require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_X86_64_PGTABLE_H)) {
    eval 'sub _X86_64_PGTABLE_H () {1;}' unless defined(&_X86_64_PGTABLE_H);
    require 'asm/processor.ph';
    require 'asm/fixmap.ph';
    require 'asm/bitops.ph';
    require 'linux/threads.ph';
    require 'asm/pda.ph';
    eval 'sub swapper_pg_dir () { &init_level4_pgt;}' unless defined(&swapper_pg_dir);
    eval 'sub ZERO_PAGE {
        my($vaddr) = @_;
	    eval q(( &virt_to_page( &empty_zero_page)));
    }' unless defined(&ZERO_PAGE);
    eval 'sub PGDIR_SHIFT () {39;}' unless defined(&PGDIR_SHIFT);
    eval 'sub PTRS_PER_PGD () {512;}' unless defined(&PTRS_PER_PGD);
    eval 'sub PUD_SHIFT () {30;}' unless defined(&PUD_SHIFT);
    eval 'sub PTRS_PER_PUD () {512;}' unless defined(&PTRS_PER_PUD);
    eval 'sub PMD_SHIFT () {21;}' unless defined(&PMD_SHIFT);
    eval 'sub PTRS_PER_PMD () {512;}' unless defined(&PTRS_PER_PMD);
    eval 'sub PTRS_PER_PTE () {512;}' unless defined(&PTRS_PER_PTE);
    eval 'sub pte_ERROR {
        my($e) = @_;
	    eval q( &printk(\\"%s:%d: bad pte %p(%016lx).\\\\n\\",  &__FILE__,  &__LINE__, ($e),  &pte_val($e)));
    }' unless defined(&pte_ERROR);
    eval 'sub pmd_ERROR {
        my($e) = @_;
	    eval q( &printk(\\"%s:%d: bad pmd %p(%016lx).\\\\n\\",  &__FILE__,  &__LINE__, ($e),  &pmd_val($e)));
    }' unless defined(&pmd_ERROR);
    eval 'sub pud_ERROR {
        my($e) = @_;
	    eval q( &printk(\\"%s:%d: bad pud %p(%016lx).\\\\n\\",  &__FILE__,  &__LINE__, ($e),  &pud_val($e)));
    }' unless defined(&pud_ERROR);
    eval 'sub pgd_ERROR {
        my($e) = @_;
	    eval q( &printk(\\"%s:%d: bad pgd %p(%016lx).\\\\n\\",  &__FILE__,  &__LINE__, ($e),  &pgd_val($e)));
    }' unless defined(&pgd_ERROR);
    eval 'sub pgd_none {
        my($x) = @_;
	    eval q((! &pgd_val($x)));
    }' unless defined(&pgd_none);
    eval 'sub pud_none {
        my($x) = @_;
	    eval q((! &pud_val($x)));
    }' unless defined(&pud_none);
    eval 'sub set_pte {
        my($dst,$val) = @_;
	    eval q({  &pte_val(*$dst) =  &pte_val($val); } );
    }' unless defined(&set_pte);
    eval 'sub set_pte_at {
        my($mm,$addr,$ptep,$pteval) = @_;
	    eval q( &set_pte($ptep,$pteval));
    }' unless defined(&set_pte_at);
    eval 'sub set_pmd {
        my($dst,$val) = @_;
	    eval q({  &pmd_val(*$dst) =  &pmd_val($val); } );
    }' unless defined(&set_pmd);
    eval 'sub set_pud {
        my($dst,$val) = @_;
	    eval q({  &pud_val(*$dst) =  &pud_val($val); });
    }' unless defined(&set_pud);
    eval 'sub pud_clear {
        my($pud) = @_;
	    eval q({  &set_pud($pud,  &__pud(0)); });
    }' unless defined(&pud_clear);
    eval 'sub set_pgd {
        my($dst,$val) = @_;
	    eval q({  &pgd_val(*$dst) =  &pgd_val($val); } );
    }' unless defined(&set_pgd);
    eval 'sub pgd_clear {
        my($pgd) = @_;
	    eval q({  &set_pgd($pgd,  &__pgd(0)); });
    }' unless defined(&pgd_clear);
    eval 'sub pud_page {
        my($pud) = @_;
	    eval q((  &__va( &pud_val($pud) &  &PHYSICAL_PAGE_MASK)));
    }' unless defined(&pud_page);
    eval 'sub ptep_get_and_clear {
        my($mm,$addr,$xp) = @_;
	    eval q( &__pte( &xchg(($xp)-> &pte, 0)));
    }' unless defined(&ptep_get_and_clear);
    eval 'sub ptep_get_and_clear_full {
        my($mm,$addr,$ptep,$full) = @_;
	    eval q({  &pte_t  &pte;  &if ($full) {  &pte = *$ptep; *$ptep =  &__pte(0); }  &else {  &pte =  &ptep_get_and_clear($mm, $addr, $ptep); }  &pte; });
    }' unless defined(&ptep_get_and_clear_full);
    eval 'sub pte_same {
        my($a, $b) = @_;
	    eval q((($a). &pte == ($b). &pte));
    }' unless defined(&pte_same);
    eval 'sub pte_pgprot {
        my($a) = @_;
	    eval q(( &__pgprot(($a). &pte & ~ &PHYSICAL_PAGE_MASK)));
    }' unless defined(&pte_pgprot);
    eval 'sub PMD_SIZE () {(1 <<  &PMD_SHIFT);}' unless defined(&PMD_SIZE);
    eval 'sub PMD_MASK () {(~( &PMD_SIZE-1));}' unless defined(&PMD_MASK);
    eval 'sub PUD_SIZE () {(1 <<  &PUD_SHIFT);}' unless defined(&PUD_SIZE);
    eval 'sub PUD_MASK () {(~( &PUD_SIZE-1));}' unless defined(&PUD_MASK);
    eval 'sub PGDIR_SIZE () {(1 <<  &PGDIR_SHIFT);}' unless defined(&PGDIR_SIZE);
    eval 'sub PGDIR_MASK () {(~( &PGDIR_SIZE-1));}' unless defined(&PGDIR_MASK);
    eval 'sub USER_PTRS_PER_PGD () {(( &TASK_SIZE-1)/ &PGDIR_SIZE+1);}' unless defined(&USER_PTRS_PER_PGD);
    eval 'sub FIRST_USER_ADDRESS () {0;}' unless defined(&FIRST_USER_ADDRESS);
    unless(defined(&__ASSEMBLY__)) {
	eval 'sub MAXMEM () {70368744177663;}' unless defined(&MAXMEM);
	eval 'sub VMALLOC_START () {1.84466759039886e+19;}' unless defined(&VMALLOC_START);
	eval 'sub VMALLOC_END () {1.84467110883607e+19;}' unless defined(&VMALLOC_END);
	eval 'sub MODULES_VADDR () {1.84467440716963e+19;}' unless defined(&MODULES_VADDR);
	eval 'sub MODULES_END () {1.84467440737085e+19;}' unless defined(&MODULES_END);
	eval 'sub MODULES_LEN () {( &MODULES_END -  &MODULES_VADDR);}' unless defined(&MODULES_LEN);
	eval 'sub _PAGE_BIT_PRESENT () {0;}' unless defined(&_PAGE_BIT_PRESENT);
	eval 'sub _PAGE_BIT_RW () {1;}' unless defined(&_PAGE_BIT_RW);
	eval 'sub _PAGE_BIT_USER () {2;}' unless defined(&_PAGE_BIT_USER);
	eval 'sub _PAGE_BIT_PWT () {3;}' unless defined(&_PAGE_BIT_PWT);
	eval 'sub _PAGE_BIT_PCD () {4;}' unless defined(&_PAGE_BIT_PCD);
	eval 'sub _PAGE_BIT_ACCESSED () {5;}' unless defined(&_PAGE_BIT_ACCESSED);
	eval 'sub _PAGE_BIT_DIRTY () {6;}' unless defined(&_PAGE_BIT_DIRTY);
	eval 'sub _PAGE_BIT_PSE () {7;}' unless defined(&_PAGE_BIT_PSE);
	eval 'sub _PAGE_BIT_GLOBAL () {8;}' unless defined(&_PAGE_BIT_GLOBAL);
	eval 'sub _PAGE_BIT_NX () {63;}' unless defined(&_PAGE_BIT_NX);
	eval 'sub _PAGE_PRESENT () {0x1;}' unless defined(&_PAGE_PRESENT);
	eval 'sub _PAGE_RW () {0x2;}' unless defined(&_PAGE_RW);
	eval 'sub _PAGE_USER () {0x4;}' unless defined(&_PAGE_USER);
	eval 'sub _PAGE_PWT () {0x8;}' unless defined(&_PAGE_PWT);
	eval 'sub _PAGE_PCD () {0x10;}' unless defined(&_PAGE_PCD);
	eval 'sub _PAGE_ACCESSED () {0x20;}' unless defined(&_PAGE_ACCESSED);
	eval 'sub _PAGE_DIRTY () {0x40;}' unless defined(&_PAGE_DIRTY);
	eval 'sub _PAGE_PSE () {0x80;}' unless defined(&_PAGE_PSE);
	eval 'sub _PAGE_FILE () {0x40;}' unless defined(&_PAGE_FILE);
	eval 'sub _PAGE_GLOBAL () {0x100;}' unless defined(&_PAGE_GLOBAL);
	eval 'sub _PAGE_PROTNONE () {0x80;}' unless defined(&_PAGE_PROTNONE);
	eval 'sub _PAGE_NX () {(1<< &_PAGE_BIT_NX);}' unless defined(&_PAGE_NX);
	eval 'sub _PAGE_TABLE () {( &_PAGE_PRESENT |  &_PAGE_RW |  &_PAGE_USER |  &_PAGE_ACCESSED |  &_PAGE_DIRTY);}' unless defined(&_PAGE_TABLE);
	eval 'sub _KERNPG_TABLE () {( &_PAGE_PRESENT |  &_PAGE_RW |  &_PAGE_ACCESSED |  &_PAGE_DIRTY);}' unless defined(&_KERNPG_TABLE);
	eval 'sub _PAGE_CHG_MASK () {( &PTE_MASK |  &_PAGE_ACCESSED |  &_PAGE_DIRTY);}' unless defined(&_PAGE_CHG_MASK);
	eval 'sub PAGE_NONE () { &__pgprot( &_PAGE_PROTNONE |  &_PAGE_ACCESSED);}' unless defined(&PAGE_NONE);
	eval 'sub PAGE_SHARED () { &__pgprot( &_PAGE_PRESENT |  &_PAGE_RW |  &_PAGE_USER |  &_PAGE_ACCESSED |  &_PAGE_NX);}' unless defined(&PAGE_SHARED);
	eval 'sub PAGE_SHARED_EXEC () { &__pgprot( &_PAGE_PRESENT |  &_PAGE_RW |  &_PAGE_USER |  &_PAGE_ACCESSED);}' unless defined(&PAGE_SHARED_EXEC);
	eval 'sub PAGE_COPY_NOEXEC () { &__pgprot( &_PAGE_PRESENT |  &_PAGE_USER |  &_PAGE_ACCESSED |  &_PAGE_NX);}' unless defined(&PAGE_COPY_NOEXEC);
	eval 'sub PAGE_COPY () { &PAGE_COPY_NOEXEC;}' unless defined(&PAGE_COPY);
	eval 'sub PAGE_COPY_EXEC () { &__pgprot( &_PAGE_PRESENT |  &_PAGE_USER |  &_PAGE_ACCESSED);}' unless defined(&PAGE_COPY_EXEC);
	eval 'sub PAGE_READONLY () { &__pgprot( &_PAGE_PRESENT |  &_PAGE_USER |  &_PAGE_ACCESSED |  &_PAGE_NX);}' unless defined(&PAGE_READONLY);
	eval 'sub PAGE_READONLY_EXEC () { &__pgprot( &_PAGE_PRESENT |  &_PAGE_USER |  &_PAGE_ACCESSED);}' unless defined(&PAGE_READONLY_EXEC);
	eval 'sub __PAGE_KERNEL () {( &_PAGE_PRESENT |  &_PAGE_RW |  &_PAGE_DIRTY |  &_PAGE_ACCESSED |  &_PAGE_NX);}' unless defined(&__PAGE_KERNEL);
	eval 'sub __PAGE_KERNEL_EXEC () {( &_PAGE_PRESENT |  &_PAGE_RW |  &_PAGE_DIRTY |  &_PAGE_ACCESSED);}' unless defined(&__PAGE_KERNEL_EXEC);
	eval 'sub __PAGE_KERNEL_NOCACHE () {( &_PAGE_PRESENT |  &_PAGE_RW |  &_PAGE_DIRTY |  &_PAGE_PCD |  &_PAGE_ACCESSED |  &_PAGE_NX);}' unless defined(&__PAGE_KERNEL_NOCACHE);
	eval 'sub __PAGE_KERNEL_RO () {( &_PAGE_PRESENT |  &_PAGE_DIRTY |  &_PAGE_ACCESSED |  &_PAGE_NX);}' unless defined(&__PAGE_KERNEL_RO);
	eval 'sub __PAGE_KERNEL_VSYSCALL () {( &_PAGE_PRESENT |  &_PAGE_USER |  &_PAGE_ACCESSED);}' unless defined(&__PAGE_KERNEL_VSYSCALL);
	eval 'sub __PAGE_KERNEL_VSYSCALL_NOCACHE () {( &_PAGE_PRESENT |  &_PAGE_USER |  &_PAGE_ACCESSED |  &_PAGE_PCD);}' unless defined(&__PAGE_KERNEL_VSYSCALL_NOCACHE);
	eval 'sub __PAGE_KERNEL_LARGE () {( &__PAGE_KERNEL |  &_PAGE_PSE);}' unless defined(&__PAGE_KERNEL_LARGE);
	eval 'sub __PAGE_KERNEL_LARGE_EXEC () {( &__PAGE_KERNEL_EXEC |  &_PAGE_PSE);}' unless defined(&__PAGE_KERNEL_LARGE_EXEC);
	eval 'sub MAKE_GLOBAL {
	    my($x) = @_;
    	    eval q( &__pgprot(($x) |  &_PAGE_GLOBAL));
	}' unless defined(&MAKE_GLOBAL);
	eval 'sub PAGE_KERNEL () { &MAKE_GLOBAL( &__PAGE_KERNEL);}' unless defined(&PAGE_KERNEL);
	eval 'sub PAGE_KERNEL_EXEC () { &MAKE_GLOBAL( &__PAGE_KERNEL_EXEC);}' unless defined(&PAGE_KERNEL_EXEC);
	eval 'sub PAGE_KERNEL_RO () { &MAKE_GLOBAL( &__PAGE_KERNEL_RO);}' unless defined(&PAGE_KERNEL_RO);
	eval 'sub PAGE_KERNEL_NOCACHE () { &MAKE_GLOBAL( &__PAGE_KERNEL_NOCACHE);}' unless defined(&PAGE_KERNEL_NOCACHE);
	eval 'sub PAGE_KERNEL_VSYSCALL32 () { &__pgprot( &__PAGE_KERNEL_VSYSCALL);}' unless defined(&PAGE_KERNEL_VSYSCALL32);
	eval 'sub PAGE_KERNEL_VSYSCALL () { &MAKE_GLOBAL( &__PAGE_KERNEL_VSYSCALL);}' unless defined(&PAGE_KERNEL_VSYSCALL);
	eval 'sub PAGE_KERNEL_LARGE () { &MAKE_GLOBAL( &__PAGE_KERNEL_LARGE);}' unless defined(&PAGE_KERNEL_LARGE);
	eval 'sub PAGE_KERNEL_VSYSCALL_NOCACHE () { &MAKE_GLOBAL( &__PAGE_KERNEL_VSYSCALL_NOCACHE);}' unless defined(&PAGE_KERNEL_VSYSCALL_NOCACHE);
	eval 'sub __P000 () { &PAGE_NONE;}' unless defined(&__P000);
	eval 'sub __P001 () { &PAGE_READONLY;}' unless defined(&__P001);
	eval 'sub __P010 () { &PAGE_COPY;}' unless defined(&__P010);
	eval 'sub __P011 () { &PAGE_COPY;}' unless defined(&__P011);
	eval 'sub __P100 () { &PAGE_READONLY_EXEC;}' unless defined(&__P100);
	eval 'sub __P101 () { &PAGE_READONLY_EXEC;}' unless defined(&__P101);
	eval 'sub __P110 () { &PAGE_COPY_EXEC;}' unless defined(&__P110);
	eval 'sub __P111 () { &PAGE_COPY_EXEC;}' unless defined(&__P111);
	eval 'sub __S000 () { &PAGE_NONE;}' unless defined(&__S000);
	eval 'sub __S001 () { &PAGE_READONLY;}' unless defined(&__S001);
	eval 'sub __S010 () { &PAGE_SHARED;}' unless defined(&__S010);
	eval 'sub __S011 () { &PAGE_SHARED;}' unless defined(&__S011);
	eval 'sub __S100 () { &PAGE_READONLY_EXEC;}' unless defined(&__S100);
	eval 'sub __S101 () { &PAGE_READONLY_EXEC;}' unless defined(&__S101);
	eval 'sub __S110 () { &PAGE_SHARED_EXEC;}' unless defined(&__S110);
	eval 'sub __S111 () { &PAGE_SHARED_EXEC;}' unless defined(&__S111);
	eval 'sub pgd_bad {
	    my($pgd) = @_;
    	    eval q({ my $val =  &pgd_val($pgd);  $val &= ~ &PTE_MASK;  $val &= ~( &_PAGE_USER |  &_PAGE_DIRTY);  $val & ~( &_PAGE_PRESENT |  &_PAGE_RW |  &_PAGE_ACCESSED); } );
	}' unless defined(&pgd_bad);
	eval 'sub pud_bad {
	    my($pud) = @_;
    	    eval q({ my $val =  &pud_val($pud);  $val &= ~ &PTE_MASK;  $val &= ~( &_PAGE_USER |  &_PAGE_DIRTY);  $val & ~( &_PAGE_PRESENT |  &_PAGE_RW |  &_PAGE_ACCESSED); });
	}' unless defined(&pud_bad);
	eval 'sub pte_none {
	    my($x) = @_;
    	    eval q((! &pte_val($x)));
	}' unless defined(&pte_none);
	eval 'sub pte_present {
	    my($x) = @_;
    	    eval q(( &pte_val($x) & ( &_PAGE_PRESENT |  &_PAGE_PROTNONE)));
	}' unless defined(&pte_present);
	eval 'sub pte_clear {
	    my($mm,$addr,$xp) = @_;
    	    eval q( &do {  &set_pte_at($mm, $addr, $xp,  &__pte(0)); }  &while (0));
	}' unless defined(&pte_clear);
	eval 'sub pages_to_mb {
	    my($x) = @_;
    	    eval q((($x) >> (20- &PAGE_SHIFT)));
	}' unless defined(&pages_to_mb);
	eval 'sub pte_page {
	    my($x) = @_;
    	    eval q( &pfn_to_page( &pte_pfn($x)));
	}' unless defined(&pte_page);
	eval 'sub pte_pfn {
	    my($x) = @_;
    	    eval q((( &pte_val($x) &  &__PHYSICAL_MASK) >>  &PAGE_SHIFT));
	}' unless defined(&pte_pfn);
	eval 'sub pfn_pte {
	    my($page_nr,$pgprot) = @_;
    	    eval q({  &pte_t  &pte;  &pte_val( &pte) = ($page_nr <<  &PAGE_SHIFT);  &pte_val( &pte) |=  &pgprot_val($pgprot);  &pte_val( &pte) &=  &__supported_pte_mask;  &pte; });
	}' unless defined(&pfn_pte);
	eval 'sub __LARGE_PTE () {( &_PAGE_PSE| &_PAGE_PRESENT);}' unless defined(&__LARGE_PTE);
	eval 'sub ptep_test_and_clear_young {
	    my($vma,$addr,$ptep) = @_;
    	    eval q({  &if (! &pte_young(*$ptep)) 0;  &test_and_clear_bit( &_PAGE_BIT_ACCESSED,  ($ptep->{pte})); });
	}' unless defined(&ptep_test_and_clear_young);
	eval 'sub ptep_set_wrprotect {
	    my($mm,$addr,$ptep) = @_;
    	    eval q({  &clear_bit( &_PAGE_BIT_RW,  ($ptep->{pte})); });
	}' unless defined(&ptep_set_wrprotect);
	eval 'sub pgprot_noncached {
	    my($prot) = @_;
    	    eval q(( &__pgprot( &pgprot_val($prot) |  &_PAGE_PCD |  &_PAGE_PWT)));
	}' unless defined(&pgprot_noncached);
	eval 'sub pmd_large {
	    my($pte) = @_;
    	    eval q({ ( &pmd_val($pte) &  &__LARGE_PTE) ==  &__LARGE_PTE; } );
	}' unless defined(&pmd_large);
	eval 'sub pgd_page {
	    my($pgd) = @_;
    	    eval q((  &__va( &pgd_val($pgd) &  &PTE_MASK)));
	}' unless defined(&pgd_page);
	eval 'sub pgd_index {
	    my($address) = @_;
    	    eval q(((($address) >>  &PGDIR_SHIFT) & ( &PTRS_PER_PGD-1)));
	}' unless defined(&pgd_index);
	eval 'sub pgd_offset {
	    my($mm, $addr) = @_;
    	    eval q((($mm)-> &pgd +  &pgd_index($addr)));
	}' unless defined(&pgd_offset);
	eval 'sub pgd_offset_k {
	    my($address) = @_;
    	    eval q(( &init_level4_pgt +  &pgd_index($address)));
	}' unless defined(&pgd_offset_k);
	eval 'sub pgd_present {
	    my($pgd) = @_;
    	    eval q(( &pgd_val($pgd) &  &_PAGE_PRESENT));
	}' unless defined(&pgd_present);
	eval 'sub mk_kernel_pgd {
	    my($address) = @_;
    	    eval q((( &pgd_t){ ($address) |  &_KERNPG_TABLE }));
	}' unless defined(&mk_kernel_pgd);
	eval 'sub pud_index {
	    my($address) = @_;
    	    eval q(((($address) >>  &PUD_SHIFT) & ( &PTRS_PER_PUD-1)));
	}' unless defined(&pud_index);
	eval 'sub pud_offset {
	    my($pgd, $address) = @_;
    	    eval q((( &pud_t *)  &pgd_page(*($pgd)) +  &pud_index($address)));
	}' unless defined(&pud_offset);
	eval 'sub pud_present {
	    my($pud) = @_;
    	    eval q(( &pud_val($pud) &  &_PAGE_PRESENT));
	}' unless defined(&pud_present);
	eval 'sub pmd_page_kernel {
	    my($pmd) = @_;
    	    eval q((  &__va( &pmd_val($pmd) &  &PTE_MASK)));
	}' unless defined(&pmd_page_kernel);
	eval 'sub pmd_page {
	    my($pmd) = @_;
    	    eval q(( &pfn_to_page( &pmd_val($pmd) >>  &PAGE_SHIFT)));
	}' unless defined(&pmd_page);
	eval 'sub pmd_index {
	    my($address) = @_;
    	    eval q(((($address) >>  &PMD_SHIFT) & ( &PTRS_PER_PMD-1)));
	}' unless defined(&pmd_index);
	eval 'sub pmd_offset {
	    my($dir, $address) = @_;
    	    eval q((( &pmd_t *)  &pud_page(*($dir)) +  &pmd_index($address)));
	}' unless defined(&pmd_offset);
	eval 'sub pmd_none {
	    my($x) = @_;
    	    eval q((! &pmd_val($x)));
	}' unless defined(&pmd_none);
	eval 'sub pmd_present {
	    my($x) = @_;
    	    eval q(( &pmd_val($x) &  &_PAGE_PRESENT));
	}' unless defined(&pmd_present);
	eval 'sub pmd_clear {
	    my($xp) = @_;
    	    eval q( &do {  &set_pmd($xp,  &__pmd(0)); }  &while (0));
	}' unless defined(&pmd_clear);
	eval 'sub pmd_bad {
	    my($x) = @_;
    	    eval q((( &pmd_val($x) & (~ &PTE_MASK & ~ &_PAGE_USER)) !=  &_KERNPG_TABLE ));
	}' unless defined(&pmd_bad);
	eval 'sub pfn_pmd {
	    my($nr,$prot) = @_;
    	    eval q(( &__pmd((($nr) <<  &PAGE_SHIFT) |  &pgprot_val($prot))));
	}' unless defined(&pfn_pmd);
	eval 'sub pmd_pfn {
	    my($x) = @_;
    	    eval q((( &pmd_val($x) &  &__PHYSICAL_MASK) >>  &PAGE_SHIFT));
	}' unless defined(&pmd_pfn);
	eval 'sub pte_to_pgoff {
	    my($pte) = @_;
    	    eval q((( &pte_val($pte) &  &PHYSICAL_PAGE_MASK) >>  &PAGE_SHIFT));
	}' unless defined(&pte_to_pgoff);
	eval 'sub pgoff_to_pte {
	    my($off) = @_;
    	    eval q((( &pte_t) { (($off) <<  &PAGE_SHIFT) |  &_PAGE_FILE }));
	}' unless defined(&pgoff_to_pte);
	eval 'sub PTE_FILE_MAX_BITS () { &__PHYSICAL_MASK_SHIFT;}' unless defined(&PTE_FILE_MAX_BITS);
	eval 'sub mk_pte {
	    my($page, $pgprot) = @_;
    	    eval q( &pfn_pte( &page_to_pfn($page), ($pgprot)));
	}' unless defined(&mk_pte);
	eval 'sub mk_pte_huge {
	    my($entry) = @_;
    	    eval q(( &pte_val($entry) |=  &_PAGE_PRESENT |  &_PAGE_PSE));
	}' unless defined(&mk_pte_huge);
	eval 'sub pte_index {
	    my($address) = @_;
    	    eval q(((($address) >>  &PAGE_SHIFT) & ( &PTRS_PER_PTE - 1)));
	}' unless defined(&pte_index);
	eval 'sub pte_offset_kernel {
	    my($dir, $address) = @_;
    	    eval q((( &pte_t *)  &pmd_page_kernel(*($dir)) +  &pte_index($address)));
	}' unless defined(&pte_offset_kernel);
	eval 'sub pte_offset_map {
	    my($dir,$address) = @_;
    	    eval q( &pte_offset_kernel($dir,$address));
	}' unless defined(&pte_offset_map);
	eval 'sub pte_offset_map_nested {
	    my($dir,$address) = @_;
    	    eval q( &pte_offset_kernel($dir,$address));
	}' unless defined(&pte_offset_map_nested);
	eval 'sub pte_unmap {
	    my($pte) = @_;
    	    eval q();
	}' unless defined(&pte_unmap);
	eval 'sub pte_unmap_nested {
	    my($pte) = @_;
    	    eval q();
	}' unless defined(&pte_unmap_nested);
	eval 'sub update_mmu_cache {
	    my($vma,$address,$pte) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&update_mmu_cache);
	eval 'sub __HAVE_ARCH_PTEP_SET_ACCESS_FLAGS () {1;}' unless defined(&__HAVE_ARCH_PTEP_SET_ACCESS_FLAGS);
	eval 'sub ptep_set_access_flags {
	    my($__vma, $__address, $__ptep, $__entry, $__dirty) = @_;
    	    eval q( &do {  &if ($__dirty) {  &set_pte($__ptep, $__entry);  &flush_tlb_page($__vma, $__address); } }  &while (0));
	}' unless defined(&ptep_set_access_flags);
	eval 'sub __swp_type {
	    my($x) = @_;
    	    eval q(((($x). &val >> 1) & 0x3f));
	}' unless defined(&__swp_type);
	eval 'sub __swp_offset {
	    my($x) = @_;
    	    eval q((($x). &val >> 8));
	}' unless defined(&__swp_offset);
	eval 'sub __swp_entry {
	    my($type, $offset) = @_;
    	    eval q((( &swp_entry_t) { (($type) << 1) | (($offset) << 8) }));
	}' unless defined(&__swp_entry);
	eval 'sub __pte_to_swp_entry {
	    my($pte) = @_;
    	    eval q((( &swp_entry_t) {  &pte_val($pte) }));
	}' unless defined(&__pte_to_swp_entry);
	eval 'sub __swp_entry_to_pte {
	    my($x) = @_;
    	    eval q((( &pte_t) { ($x). &val }));
	}' unless defined(&__swp_entry_to_pte);
    }
    eval 'sub io_remap_pfn_range {
        my($vma, $vaddr, $pfn, $size, $prot) = @_;
	    eval q( &remap_pfn_range($vma, $vaddr, $pfn, $size, $prot));
    }' unless defined(&io_remap_pfn_range);
    eval 'sub MK_IOSPACE_PFN {
        my($space, $pfn) = @_;
	    eval q(($pfn));
    }' unless defined(&MK_IOSPACE_PFN);
    eval 'sub GET_IOSPACE {
        my($pfn) = @_;
	    eval q(0);
    }' unless defined(&GET_IOSPACE);
    eval 'sub GET_PFN {
        my($pfn) = @_;
	    eval q(($pfn));
    }' unless defined(&GET_PFN);
    eval 'sub HAVE_ARCH_UNMAPPED_AREA () {1;}' unless defined(&HAVE_ARCH_UNMAPPED_AREA);
    eval 'sub pgtable_cache_init () {
        eval q( &do { }  &while (0));
    }' unless defined(&pgtable_cache_init);
    eval 'sub check_pgt_cache () {
        eval q( &do { }  &while (0));
    }' unless defined(&check_pgt_cache);
    eval 'sub PAGE_AGP () { &PAGE_KERNEL_NOCACHE;}' unless defined(&PAGE_AGP);
    eval 'sub HAVE_PAGE_AGP () {1;}' unless defined(&HAVE_PAGE_AGP);
    eval 'sub kc_vaddr_to_offset {
        my($v) = @_;
	    eval q((($v) &  &__VIRTUAL_MASK));
    }' unless defined(&kc_vaddr_to_offset);
    eval 'sub kc_offset_to_vaddr {
        my($o) = @_;
	    eval q(((($o) & (1 << ( &__VIRTUAL_MASK_SHIFT-1))) ? (($o) | (~ &__VIRTUAL_MASK)) : ($o)));
    }' unless defined(&kc_offset_to_vaddr);
    eval 'sub __HAVE_ARCH_PTEP_TEST_AND_CLEAR_YOUNG () {1;}' unless defined(&__HAVE_ARCH_PTEP_TEST_AND_CLEAR_YOUNG);
    eval 'sub __HAVE_ARCH_PTEP_TEST_AND_CLEAR_DIRTY () {1;}' unless defined(&__HAVE_ARCH_PTEP_TEST_AND_CLEAR_DIRTY);
    eval 'sub __HAVE_ARCH_PTEP_GET_AND_CLEAR () {1;}' unless defined(&__HAVE_ARCH_PTEP_GET_AND_CLEAR);
    eval 'sub __HAVE_ARCH_PTEP_GET_AND_CLEAR_FULL () {1;}' unless defined(&__HAVE_ARCH_PTEP_GET_AND_CLEAR_FULL);
    eval 'sub __HAVE_ARCH_PTEP_SET_WRPROTECT () {1;}' unless defined(&__HAVE_ARCH_PTEP_SET_WRPROTECT);
    eval 'sub __HAVE_ARCH_PTE_SAME () {1;}' unless defined(&__HAVE_ARCH_PTE_SAME);
    require 'asm-generic/pgtable.ph';
}
1;
