require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_I386_TOPOLOGY_H)) {
    eval 'sub _ASM_I386_TOPOLOGY_H () {1;}' unless defined(&_ASM_I386_TOPOLOGY_H);
    if(defined(&CONFIG_X86_HT)) {
	eval 'sub topology_physical_package_id {
	    my($cpu) = @_;
    	    eval q(( ($cpu_data[$cpu]->{phys_proc_id})));
	}' unless defined(&topology_physical_package_id);
	eval 'sub topology_core_id {
	    my($cpu) = @_;
    	    eval q(( ($cpu_data[$cpu]->{cpu_core_id})));
	}' unless defined(&topology_core_id);
	eval 'sub topology_core_siblings {
	    my($cpu) = @_;
    	    eval q(( $cpu_core_map[$cpu]));
	}' unless defined(&topology_core_siblings);
	eval 'sub topology_thread_siblings {
	    my($cpu) = @_;
    	    eval q(( $cpu_sibling_map[$cpu]));
	}' unless defined(&topology_thread_siblings);
    }
    if(defined(&CONFIG_NUMA)) {
	require 'asm/mpspec.ph';
	require 'linux/cpumask.ph';
	eval 'sub parent_node {
	    my($node) = @_;
    	    eval q(($node));
	}' unless defined(&parent_node);
	eval 'sub pcibus_to_node {
	    my($bus) = @_;
    	    eval q(( ($bus)-> &sysdata));
	}' unless defined(&pcibus_to_node);
	eval 'sub pcibus_to_cpumask {
	    my($bus) = @_;
    	    eval q( &node_to_cpumask( &pcibus_to_node($bus)));
	}' unless defined(&pcibus_to_cpumask);
	eval 'sub SD_NODE_INIT () { { . &span =  &CPU_MASK_NONE, . &parent =  &NULL, . &groups =  &NULL, . &min_interval = 8, . &max_interval = 32, . &busy_factor = 32, . &imbalance_pct = 125, . &cache_nice_tries = 1, . &busy_idx = 3, . &idle_idx = 1, . &newidle_idx = 2, . &wake_idx = 1, . &per_cpu_gain = 100, . &flags =  &SD_LOAD_BALANCE |  &SD_BALANCE_EXEC |  &SD_BALANCE_FORK |  &SD_WAKE_BALANCE, . &last_balance =  &jiffies, . &balance_interval = 1, . &nr_balance_failed = 0, };}' unless defined(&SD_NODE_INIT);
	eval 'sub node_has_online_mem {
	    my($nid) = @_;
    	    eval q(( $node_start_pfn[$nid] !=  $node_end_pfn[$nid]));
	}' unless defined(&node_has_online_mem);
    } else {
	require 'asm-generic/topology.ph';
    }
    if(defined(&CONFIG_SMP)) {
	eval 'sub mc_capable () {
	    eval q(( ($boot_cpu_data->{x86_max_cores}) > 1));
	}' unless defined(&mc_capable);
	eval 'sub smt_capable () {
	    eval q(( &smp_num_siblings > 1));
	}' unless defined(&smt_capable);
    }
}
1;
