require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ASM_SYSTEM_H)) {
    eval 'sub __ASM_SYSTEM_H () {1;}' unless defined(&__ASM_SYSTEM_H);
    require 'linux/kernel.ph';
    require 'asm/segment.ph';
    require 'asm/cpufeature.ph';
    require 'linux/bitops.ph';
    if(defined(&__KERNEL__)) {
	eval 'sub switch_to {
	    my($prev,$next,$last) = @_;
    	    eval q( &do { \'unsigned long esi\', &edi;  &asm  &volatile(\\"pushfl\\\\n\\\\t\\" \\"pushl %%ebp\\\\n\\\\t\\" \\"movl %%esp,%0\\\\n\\\\t\\" \\"movl %5,%%esp\\\\n\\\\t\\" \\"movl $1f,%1\\\\n\\\\t\\" \\"pushl %6\\\\n\\\\t\\" \\"jmp __switch_to\\\\n\\" \\"1:\\\\t\\" \\"popl %%ebp\\\\n\\\\t\\" \\"popfl\\" :\\"=m\\" ( ($prev->{thread}->{esp})),\\"=m\\" ( ($prev->{thread}->{eip})), \\"=a\\" ($last),\\"=S\\" ( &esi),\\"=D\\" ( &edi) :\\"m\\" ( ($next->{thread}->{esp})),\\"m\\" ( ($next->{thread}->{eip})), \\"2\\" ($prev), \\"d\\" ($next)); }  &while (0));
	}' unless defined(&switch_to);
	eval 'sub _set_base {
	    my($addr,$base) = @_;
    	    eval q(\\"(assembly code)\\");
	}' unless defined(&_set_base);
	eval 'sub _set_limit {
	    my($addr,$limit) = @_;
    	    eval q(\\"(assembly code)\\");
	}' unless defined(&_set_limit);
	eval 'sub set_base {
	    my($ldt,$base) = @_;
    	    eval q( &_set_base( (($ldt)) , ($base) ));
	}' unless defined(&set_base);
	eval 'sub set_limit {
	    my($ldt,$limit) = @_;
    	    eval q( &_set_limit( (($ldt)) , (($limit)-1) ));
	}' unless defined(&set_limit);
	eval 'sub loadsegment {
	    my($seg,$value) = @_;
    	    eval q( &asm  &volatile(\\"\\\\n\\" \\"1:\\\\t\\" \\"mov %0,%%\\" $seg \\"\\\\n\\" \\"2:\\\\n\\" \\".section .fixup,\\\\\\"ax\\\\\\"\\\\n\\" \\"3:\\\\t\\" \\"pushl $0\\\\n\\\\t\\" \\"popl %%\\" $seg \\"\\\\n\\\\t\\" \\"jmp 2b\\\\n\\" \\".previous\\\\n\\" \\".section __ex_table,\\\\\\"a\\\\\\"\\\\n\\\\t\\" \\".align 4\\\\n\\\\t\\" \\".long 1b,3b\\\\n\\" \\".previous\\" : :\\"rm\\" ($value)));
	}' unless defined(&loadsegment);
	eval 'sub savesegment {
	    my($seg, $value) = @_;
    	    eval q( &asm  &volatile(\\"mov %%\\" $seg \\",%0\\":\\"=rm\\" ($value)));
	}' unless defined(&savesegment);
	eval 'sub read_cr0 () {
	    eval q(\\"(assembly code)\\");
	}' unless defined(&read_cr0);
	eval 'sub write_cr0 {
	    my($x) = @_;
    	    eval q(\\"(assembly code)\\");
	}' unless defined(&write_cr0);
	eval 'sub read_cr2 () {
	    eval q(\\"(assembly code)\\");
	}' unless defined(&read_cr2);
	eval 'sub write_cr2 {
	    my($x) = @_;
    	    eval q(\\"(assembly code)\\");
	}' unless defined(&write_cr2);
	eval 'sub read_cr3 () {
	    eval q(\\"(assembly code)\\");
	}' unless defined(&read_cr3);
	eval 'sub write_cr3 {
	    my($x) = @_;
    	    eval q(\\"(assembly code)\\");
	}' unless defined(&write_cr3);
	eval 'sub read_cr4 () {
	    eval q(\\"(assembly code)\\");
	}' unless defined(&read_cr4);
	eval 'sub read_cr4_safe () {
	    eval q(\\"(assembly code)\\");
	}' unless defined(&read_cr4_safe);
	eval 'sub write_cr4 {
	    my($x) = @_;
    	    eval q(\\"(assembly code)\\");
	}' unless defined(&write_cr4);
	eval 'sub clts () {
	    eval q(\\"(assembly code)\\");
	}' unless defined(&clts);
	eval 'sub stts () {
	    eval q( &write_cr0(8|  &read_cr0()));
	}' unless defined(&stts);
    }
    eval 'sub wbinvd () {
        eval q(\\"(assembly code)\\");
    }' unless defined(&wbinvd);
    eval 'sub get_limit {
        my($segment) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&get_limit);
    eval 'sub nop () {
        eval q(\\"(assembly code)\\");
    }' unless defined(&nop);
    eval 'sub xchg {
        my($ptr,$v) = @_;
	    eval q((( &__typeof__(*($ptr))) &__xchg(($v),($ptr),$sizeof{($ptr)})));
    }' unless defined(&xchg);
    eval 'sub tas {
        my($ptr) = @_;
	    eval q(( &xchg(($ptr),1)));
    }' unless defined(&tas);
    eval 'sub __xg {
        my($x) = @_;
	    eval q((($x)));
    }' unless defined(&__xg);
    if(defined(&CONFIG_X86_CMPXCHG64)) {
	eval 'sub __set_64bit_constant {
	    my($ptr,$value) = @_;
    	    eval q({  &__set_64bit($ptr,($value), (($value)>>32)); });
	}' unless defined(&__set_64bit_constant);
	eval 'sub ll_low {
	    my($x) = @_;
    	    eval q(*((($x))+0));
	}' unless defined(&ll_low);
	eval 'sub ll_high {
	    my($x) = @_;
    	    eval q(*((($x))+1));
	}' unless defined(&ll_high);
	eval 'sub __set_64bit_var {
	    my($ptr,$value) = @_;
    	    eval q({  &__set_64bit($ptr, &ll_low($value),  &ll_high($value)); });
	}' unless defined(&__set_64bit_var);
	eval 'sub set_64bit {
	    my($ptr,$value) = @_;
    	    eval q(( &__builtin_constant_p($value) ?  &__set_64bit_constant($ptr, $value) :  &__set_64bit_var($ptr, $value) ));
	}' unless defined(&set_64bit);
	eval 'sub _set_64bit {
	    my($ptr,$value) = @_;
    	    eval q(( &__builtin_constant_p($value) ?  &__set_64bit($ptr, ($value), (($value)>>32) ) :  &__set_64bit($ptr,  &ll_low($value),  &ll_high($value)) ));
	}' unless defined(&_set_64bit);
    }
    if(defined(&CONFIG_X86_CMPXCHG)) {
	eval 'sub __HAVE_ARCH_CMPXCHG () {1;}' unless defined(&__HAVE_ARCH_CMPXCHG);
	eval 'sub cmpxchg {
	    my($ptr,$o,$n) = @_;
    	    eval q((( &__typeof__(*($ptr))) &__cmpxchg(($ptr),($o), ($n),$sizeof{($ptr)})));
	}' unless defined(&cmpxchg);
    }
    eval 'sub __cmpxchg {
        my($ptr,$old,$new,$size) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&__cmpxchg);
    unless(defined(&CONFIG_X86_CMPXCHG)) {
	eval 'sub cmpxchg_386 {
	    my($ptr,$old,$new,$size) = @_;
    	    eval q({  &switch ($size) {  &case 1:  &cmpxchg_386_u8($ptr, $old, $new);  &case 2:  &cmpxchg_386_u16($ptr, $old, $new);  &case 4:  &cmpxchg_386_u32($ptr, $old, $new); } $old; });
	}' unless defined(&cmpxchg_386);
	eval 'sub cmpxchg {
	    my($ptr,$o,$n) = @_;
    	    eval q(({  &__typeof__(*($ptr))  &__ret;  &if ( &likely( ($b$oot_cpu_data->{x86}) > 3))  &__ret =  &__cmpxchg(($ptr), ($o), ($n), $sizeof{($ptr)});  &else  &__ret =  &cmpxchg_386(($ptr), ($o), ($n), $sizeof{($ptr)});  &__ret; }));
	}' unless defined(&cmpxchg);
    }
    if(defined(&CONFIG_X86_CMPXCHG64)) {
	eval 'sub __cmpxchg64 {
	    my($ptr,$old,$new) = @_;
    	    eval q(\\"(assembly code)\\");
	}' unless defined(&__cmpxchg64);
	eval 'sub cmpxchg64 {
	    my($ptr,$o,$n) = @_;
    	    eval q((( &__typeof__(*($ptr))) &__cmpxchg64(($ptr),($o), ($n))));
	}' unless defined(&cmpxchg64);
    }
    eval 'sub mb () {
        eval q( &alternative(\\"lock; addl $0,0(%%esp)\\", \\"mfence\\",  &X86_FEATURE_XMM2));
    }' unless defined(&mb);
    eval 'sub rmb () {
        eval q( &alternative(\\"lock; addl $0,0(%%esp)\\", \\"lfence\\",  &X86_FEATURE_XMM2));
    }' unless defined(&rmb);
    eval 'sub read_barrier_depends () {
        eval q( &do { }  &while(0));
    }' unless defined(&read_barrier_depends);
    if(defined(&CONFIG_X86_OOSTORE)) {
	eval 'sub wmb () {
	    eval q( &alternative(\\"lock; addl $0,0(%%esp)\\", \\"sfence\\",  &X86_FEATURE_XMM));
	}' unless defined(&wmb);
    } else {
	eval 'sub wmb () {
	    eval q(\\"(assembly code)\\");
	}' unless defined(&wmb);
    }
    if(defined(&CONFIG_SMP)) {
	eval 'sub smp_mb () {
	    eval q( &mb());
	}' unless defined(&smp_mb);
	eval 'sub smp_rmb () {
	    eval q( &rmb());
	}' unless defined(&smp_rmb);
	eval 'sub smp_wmb () {
	    eval q( &wmb());
	}' unless defined(&smp_wmb);
	eval 'sub smp_read_barrier_depends () {
	    eval q( &read_barrier_depends());
	}' unless defined(&smp_read_barrier_depends);
	eval 'sub set_mb {
	    my($var, $value) = @_;
    	    eval q( &do { ( &void)  &xchg($var, $value); }  &while (0));
	}' unless defined(&set_mb);
    } else {
	eval 'sub smp_mb () {
	    eval q( &barrier());
	}' unless defined(&smp_mb);
	eval 'sub smp_rmb () {
	    eval q( &barrier());
	}' unless defined(&smp_rmb);
	eval 'sub smp_wmb () {
	    eval q( &barrier());
	}' unless defined(&smp_wmb);
	eval 'sub smp_read_barrier_depends () {
	    eval q( &do { }  &while(0));
	}' unless defined(&smp_read_barrier_depends);
	eval 'sub set_mb {
	    my($var, $value) = @_;
    	    eval q( &do { $var = $value;  &barrier(); }  &while (0));
	}' unless defined(&set_mb);
    }
    require 'linux/irqflags.ph';
    eval 'sub HAVE_DISABLE_HLT () {1;}' unless defined(&HAVE_DISABLE_HLT);
}
1;
